<?php
/* --------------------------------------------------------------
   GambioHubPayPalInstallments.inc.php 2020-05-08
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

class GambioHubPayPalInstallments extends GambioHubPayPalInstallments_parent
{
    public function getInstallmentInfo($amount = 0, $currency = 'EUR', $country = STORE_COUNTRY)
    {
        if(strtolower((string)@constant('MODULE_PAYMENT_GAMBIO_HUB_STATUS')) !== 'true') {
            return parent::getInstallmentInfo($amount, $currency, $country);
        }
        $hubPayPalConfiguration = MainFactory::create('HubPayPalConfiguration');
        if ($hubPayPalConfiguration->isInstallmentsActive()) {
            return $this->getInstallmentInfoViaGambioHub($amount, $currency, $country);
        }
        
        return parent::getInstallmentInfo($amount, $currency, $country);
    }
    
    
    public function getInstallmentInfoViaGambioHub($amount = 0, $currency = 'EUR', $country = STORE_COUNTRY)
    {
        $amountString     = number_format((float)$amount, 2, '.', '');
        $financingOptions = json_encode(
            [
                'financing_country_code' => $country,
                'transaction_amount'     => [
                    'value'         => $amountString,
                    'currency_code' => $currency,
                ],
            ]
        );
        if (property_exists($this, 'logger')) {
            $this->logger->iup_notice(
                sprintf('fetching data for upstream presentment, %s %s (%s)', $amountString, $currency, $country)
            );
        }
        $request = MainFactory::create(
            'PayPalRestRequest',
            'POST',
            '/v1/credit/calculated-financing-options',
            $financingOptions,
            'inst_hub'
        );
        $service = MainFactory::create('PayPalRestService');
        $service->setLogRawResponseEnabled(false);
        $service->setLogDecodedResponseEnabled(false);
        $response     = $service->performRequest($request);
        $responseBody = $response->getResponseObject();
        if ($responseBody !== false) {
            $this->logResponse($responseBody);
            usort(
                $responseBody->financing_options[0]->qualifying_financing_options,
                function ($a, $b) {
                    return ($a->credit_financing->term < $b->credit_financing->term) ? -1 : 1;
                }
            );
        } else {
            if (property_exists($this, 'logger')) {
                $this->logger->iup_notice('ERROR retrieving data for upstream presentment!');
            }
        }
        
        return $responseBody;
    }
    
}
